function c=centroidT1(A)

%
% c=centroidT1(A)
%
% To compute the centroid of a trapezoidal T1 FS defined by 5
% parameters (e, f, g, i, h) shown in Fig. 1 of Readme.doc. 
%
% If A has only four parameters, then its height is considered as 1. But
% actually the height is not useful in computing the centroid.
%
% Dongrui WU (dongruiw@usc.edu), 11/16/2008
%
% A: a T1 FS represented by 5 parameters.
%
% c: center of centroid of A


N=200; % number of discretizations
dx=(A(4)-A(1))/N;  
muA=zeros(N+1,1);
for j=1:N+1
    x=A(1)+(j-1)*dx;
    
    if x<=A(1)| x>=A(4)
        muA(j)=0;
    elseif  x<A(2)
        muA(j)=(x-A(1))/(A(2)-A(1));
    elseif  x<=A(3);
        muA(j)=1;
    else 
        muA(j)=(A(4)-x)/(A(4)-A(3));
    end
end

%% centroid of A
c=[A(1):dx:A(4)]*muA/sum(muA);

